
#Include Once "./Core/Code/Gfx Manip/Gfx Manip.bas"

Declare Sub Gfx_Buffer_Flip ( ByRef Source As FB.Image Ptr, ByRef Dest As FB.Image Ptr, X As Long = 0, Y As Long = 0 )

Sub Gfx_Buffer_Flip ( ByRef Source As FB.Image Ptr, ByRef Dest As FB.Image Ptr, X As Long = 0, Y As Long = 0 )
	
	If X = 0 And Y = 0 Then
		
		Dest = Source
		Exit Sub
		
	End If
	
	Dim As Long pX = 0, pY = 0
	
	Dim As FB.Image Ptr Intermediary, IntermediaryX, IntermediaryY
	
	Intermediary = ImageCreate ( Source - > Width, Source - > Height, RGBA ( 0, 0, 0, 0 ), 32 )
	
	Put Intermediary, ( 0, 0 ), Source, PSet

	If X Then /' X Axis '/
		
		IntermediaryX = ImageCreate ( Intermediary - > Width, Intermediary - > Height, RGBA ( 0, 0, 0, 0 ), 32 )
	
		For pX = 0 To IntermediaryX - > Width - 1 Step 1
	
			Put IntermediaryX, ( pX, 0 ), Intermediary, ( IntermediaryX - > Width - pX, 0 ) - ( IntermediaryX - > Width - pX, IntermediaryX - > Height - 1 ), PSet
			
		Next pX

		Put Intermediary, ( 0, 0 ), IntermediaryX, PSet

	End If

	If Y Then /' Y Axis '/

		IntermediaryY = ImageCreate ( Intermediary - > Width, Intermediary - > Height, RGBA ( 0, 0, 0, 0 ), 32 )
	
		For pY = 0 To IntermediaryY - > Width - 1 Step 1
	
			Put IntermediaryY, ( 0, pY ), Intermediary, ( 0, IntermediaryY - > Height - pY ) - ( IntermediaryY - > Width - 1, IntermediaryY - > Height - pY ), PSet
		
		Next pY

		Put Intermediary, ( 0, 0 ), IntermediaryY, PSet

	End If
	
	ImageDestroy ( IntermediaryX )
	ImageDestroy ( IntermediaryY )
	
	Dest = ImageCreate ( Intermediary - > Width, Intermediary - > Height, RGBA ( 0, 0, 0, 0 ), 32 )

	Put Dest, ( 0, 0 ), Intermediary, PSet

	ImageDestroy ( Intermediary )
	
End Sub
